﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;

namespace Programming_CSharp
{
    public class Customer
    {
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string EmailAddress { get; set; }
    }

    public class Tester
    {
        private static XDocument CreateCustomerListXml()
        {
            List<Customer> customers = CreateCustomerList();
            var customerXml = new XDocument(new XElement("Customers",
                from customer in customers
                select new XElement("Customer",
                new XAttribute("FirstName", customer.FirstName),
                new XAttribute("LastName", customer.LastName),
                new XElement("EmailAddress", customer.EmailAddress)
                )));
            return customerXml;
        }

        private static List<Customer> CreateCustomerList()
        {
            List<Customer> customers = new List<Customer>
                {
                new Customer { FirstName = "Stanisław",
                               LastName = "Lem",
                               EmailAddress = "sLem@niema.pl"},
                new Customer { FirstName = "Ryszard",
                               LastName = "Kapuściński",
                               EmailAddress = "rKapu0@niema.pl"},
                new Customer { FirstName = "Dorota",
                               LastName = "Masłowska",
                               EmailAddress = "dMaslowska@niema.pl"},
                new Customer { FirstName = "Jan",
                               LastName = "Twardowski",
                               EmailAddress = "jTwardowski@niema.pl"},
                new Customer { FirstName = "Norman",
                               LastName = "Davies",
                               EmailAddress = "nDavies@niema.pl"},
                new Customer { FirstName = "Renata",
                               LastName = "Beger",
                               EmailAddress = "rBeger@niema.pl"},
                new Customer { FirstName = "Michał",
                               LastName = "Wiśniewski",
                               EmailAddress = "mWisniewski@niema.pl"},
                new Customer { FirstName = "Leonard",
                               LastName = "Niedźwiecki",
                               EmailAddress = "lNiedzwiecki@niema.pl"},
                new Customer { FirstName = "Joanna",
                               LastName = "Chmielewska",
                               EmailAddress = "jChmielewska@niema.pl"}
                };
            return customers;
        }

        static void Main()
        {
            XDocument customerXml = CreateCustomerListXml();

            Console.WriteLine("Wyszukiwanie pojedynczego elementu...");
            var query =
                from customer in customerXml.Element("Customers").Elements("Customer")
                where customer.Attribute("FirstName").Value == "Stanisław"
                select customer;
            XElement oneCustomer = query.SingleOrDefault();
            if (oneCustomer != null)
            {
                Console.WriteLine(oneCustomer);
            }
            else
            {
                Console.WriteLine("Nie znaleziono");
            }

            Console.WriteLine("\nWyszukiwanie przy użyciu osi potomków... ");
            query = from customer in customerXml.Descendants("Customer")
                where customer.Attribute("FirstName").Value == "Stanisław"
                select customer;
            oneCustomer = query.SingleOrDefault();
            if (oneCustomer != null)
            {
                Console.WriteLine(oneCustomer);
            }
            else
            {
                Console.WriteLine("Nie znaleziono");
            }

            Console.WriteLine("\nWyszukiwanie przy użyciu wartości elementu... ");
            query = from emailAddress in customerXml.Descendants("EmailAddress")
                where emailAddress.Value == "sLem@niema.pl"
                select emailAddress;
            XElement oneEmail = query.SingleOrDefault();
            if (oneEmail != null)
            {
                Console.WriteLine(oneEmail);
            }
            else
            {
                Console.WriteLine("Nie znaleziono");
            }

            Console.WriteLine("\nWyszukiwanie przy użyciu wartości elementu dziecka... ");
            query = from customer in customerXml.Descendants("Customer")
                where customer.Element("EmailAddress").Value == "sLem@niema.pl"
                select customer;
            oneCustomer = query.SingleOrDefault();
            if (oneCustomer != null)
            {
                Console.WriteLine(oneCustomer);
            }
            else
            {
                Console.WriteLine("Nie znaleziono");
            }
        } // koniec main
    } // koniec class
} // koniec namespace
